
* File calcspec1.inc

$ONTEXT
This calc file forms a blend of the specified subset of wastes (specified in w\
astcomp.prn) and performs a single optimization with the blended waste.
Each waste to be blended is a column in the table (matrix) WasteComps).
$OFFTEXT

SCALAR BlendMass  Total mass of blended wastes;

MassOxide    = SUM(CalcSet,WasteComps('OxideMass', CalcSet));

FW(C)  = SUM(CalcSet,WasteComps(C, CalcSet)*
                WasteComps('OxideMass', CalcSet))/MassOxide;

FG.L(I)   = (FF.L(I)*TMFG.L + FW(I)*TMWG.L)/MaxLogMass;

SOLVE WASTEOPTIM MAXIMIZING WasteFrac USING NLP;

CanMass   = MaxLogMass;
NumCans   = MassOxide/TMWG.L;
Viscosity = EXP(SUM(I,AV(I)*FG.L(I)) + SUM((I,J),BV(I,J)*FG.L(I)*FG.L(J)));
ElectCond = EXP(SUM(I,AE(I)*FG.L(I)) + SUM((I,J),BE(I,J)*FG.L(I)*FG.L(J)));
BorDissPCT= EXP(SUM(I,ADPB(I)*FG.L(I)) + SUM((I,J),BDPB(I,J)*FG.L(I)*FG.L(J)));
BorDissMCC= EXP(SUM(I,ADMB(I)*FG.L(I)) + SUM((I,J),BDMB(I,J)*FG.L(I)*FG.L(J)));
Frit      = Numcans*TMFG.L;

  Display Frit;
  Display WasteFrac.L;
  Display MassOxide, NumCans;
  Display TMWG.L, TMFG.L;
  Display Viscosity, ElectCond, BorDissPCT, BorDissMCC;
  Display FW, FF.L, FG.L ;

